<?php

namespace Modules\Setting\Http\Controllers;

use App\ImageManager;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Modules\Setting\Entities\Setting;

class AdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:manage-settings');
    }
    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $settings = Setting::latest()->get();

        return view()->first(['admin.settings.index', 'setting::index'] , compact('settings'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        return view('setting::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        return view('setting::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit($id)
    {
        $setting = Setting::findorFail($id);
        return view()->first(['admin.settings.edit', 'setting::edit'], compact('setting'));
    }

    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $setting = Setting::findOrFail($id);
        if ($setting->type=='file') {
            if ($request->hasFile('value')) {
                $name = Str::random(64);
                if ($request->value->storeAs('public/files/settings/' . date('Y/m'), $name . '.' . $request->value->extension())) {
                    $setting->value = 'storage/files/settings/' . date('Y/m') . '/' . $name . '.' . $request->value->extension();
                }
            }
        }
        else {
            $setting->value = $request->input('value');
        }

        $setting->save();

        session()->flash('msg', [
            'status'  => 'success',
            'title'   => '',
            'message' => "تنظیمات $setting->label ویرایش شد."
        ]);

        return redirect()->route('admin.settings.index');
    }

    /**
     * Remove the specified resource from storage.
     * @return Response
     */
    public function destroy()
    {
    }
}
