<?php

namespace Modules\User\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Faker\Generator as Faker;
use Illuminate\Support\Facades\DB;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @param Faker $faker
     * @return void
     */
    public function run(Faker $faker)
    {
        Model::unguard();

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        DB::table('users')->truncate();

        $users = [
            [
                'first_name' => 'مجتبی',
                'last_name' => 'پاکزاد',
                'mobile' => '09337557488',
                'email' => 'admin@gmail.com',
                'email_verified_at' => now(),
                'password' => bcrypt('123456'),
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'first_name' => $faker->firstName,
                'last_name' => $faker->lastName,
                'mobile' => '09123456789',
                'email' => $faker->email,
                'email_verified_at' => now(),
                'password' => bcrypt('1223456'),
                'created_at' => now(),
                'updated_at' => now()
            ],
        ];

        DB::table('users')->insert($users);

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        Model::reguard();
    }
}
