<?php

namespace Modules\User\Http\Controllers;

use App\Models\BlockedUser;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Province\Entities\Province;
use Modules\User\Http\Requests\StoreUser;
use Modules\User\Http\Requests\UpdateUser;
use Spatie\Activitylog\Models\Activity;
use Spatie\Permission\Models\Role;

class AdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:manage-users');
    }

    public function index()
    {
        $users = User::latest()->get();

        return view('admin.users.index', compact('users'));
    }

    public function indexBlockedUsers()
    {
        $users = BlockedUser::latest()->get();

        return view('admin.users.blocked.index', compact('users'));
    }

    public function createBlockedUsers()
    {
        return view('admin.users.blocked.create');
    }

    public function storeBlockedUsers(Request $request)
    {
        $user = new BlockedUser();
        $user->name          = $request->name;
        $user->mobile        = $request->mobile;
        $user->national_code = $request->national_code;
        $user->save();

        $this->doneMessage('با موفقیت به لیست بلاک اضافه شد.');
        return redirect()->route('admin.blocked_users.index');
    }

    public function destroyBlockedUsers($id)
    {
        BlockedUser::where('id', $id)->delete();

        $this->doneMessage('با موفقیت از لیست بلاک حذف شد.');
        return redirect()->back();
    }

}
