<?php

namespace Modules\User\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUser extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name'    => 'required',
            'last_name'     => 'required',
            'role'          => 'required|exists:roles,id',
            'email'         => 'required|unique:users,email,' .  $this->route('user'),
            'mobile'        => 'required|unique:users,mobile,' .  $this->route('user'),
            'city'          => 'nullable|exists:cities,id',
            'phone'         => 'nullable|size:11',
            'post_code'     => 'nullable|size:10',
            'address'       => 'nullable',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
