<?php

namespace App\Http\Controllers;

use App\Models\BlockedUser;
use App\Models\Buyer;
use Illuminate\Http\Request;
use Modules\Setting\Entities\Setting;

class AppController extends Controller
{
    public function sendVerificationCode(Request $request)
    {
        $mobile        = $request->mobile;
        $national_code = $request->national_code;

        $is_mobile_exist        = BlockedUser::where('mobile', $mobile)->first();
        $is_national_code_exist = BlockedUser::where('national_code', $national_code)->first();
        
        if (!is_null($is_mobile_exist) || !is_null($is_national_code_exist)) {
            return json_encode([
                'status' => 'NOK',
            ]);
        }

        $token = getJibitToken();
        
        if ($token) {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL            => env('JIBIT_BASE_URL').'/v1/services/matching?nationalCode='.$national_code.'&mobileNumber='.$mobile,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING       => '',
                CURLOPT_MAXREDIRS      => 10,
                CURLOPT_TIMEOUT        => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST  => 'GET',
                CURLOPT_POSTFIELDS     => '',
                CURLOPT_HTTPHEADER     => array(
                    'Content-Type: application/json',
                    'Authorization: Bearer '.$token
                ),
            ));

            $response = json_decode(curl_exec($curl));

            curl_close($curl);

            if (!$response->matched) {
                return json_encode([
                    'status' => 'NOK',
                ]);
            }
            else {
                $code = rand(111111, 999999);
                $buyer = new Buyer();
                $buyer->mobile            = $mobile;
                $buyer->national_code     = $national_code;
                $buyer->verification_code = $code;
                $buyer->amount            = session()->get('amount');
                $buyer->save();

                //SMS TO USER 
                SendSMS($mobile, $code, '229228');
                return json_encode([
                    'status'   => 'OK',
                    'buyer_id' => $buyer->id
                ]);
            }
        }
        else {
            return json_encode([
                'status' => 'NOK',
            ]);
        }
    }

    public function checkVerificationCode(Request $request)
    {
        $mobile        = $request->mobile;
        $national_code = $request->national_code;
        $code          = $request->code;

        $data = Buyer::where([
            ['mobile', $mobile],
            ['national_code', $national_code],
            ['verification_code', $code]
        ])->first();
        if (!$data) {
            return json_encode([
                'status' => 'NOK',
            ]);
        }
        else {
            return json_encode([
                'status' => 'OK',
                'url'    => route('pay.go_to_pay_gate')
            ]);
        }
    }

}
