<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Spatie\Activitylog\Models\Activity;

class LogController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:manage-users');
    }

    public function index()
    {
        $logs = Activity::latest()->paginate(50);

        return view('admin.logs.index', compact('logs'));
    }

    public function destroy(Request $request)
    {
        if ($request->type == 1) {
            Activity::truncate();
            activity()->log('حذف تمام گزارشات');
        }
        elseif ($request->type == 2) {
            $activity = Activity::where('created_at',  '<', Carbon::now()->subWeek());
            if(!$activity->count()) {
                session()->flash('msg', [
                    'status' => 'error',
                    'title' => '',
                    'message' => "گزارشی برای حذف یافت نشد."
                ]);
                return redirect()->route('admin.logs.index');
            }
            $activity->delete();
            activity()->log('حذف گزارشات تا هفته قبل');
        }

        session()->flash('msg', [
            'status' => 'success',
            'title' => '',
            'message' => "با موفقیت حذف شد."
        ]);

        return redirect()->route('admin.logs.index');
    }
}
