<?php

namespace App\Providers;

use Illuminate\Support\Arr;
use Illuminate\Support\ServiceProvider;
use Illuminate\View\View;
use Modules\Banner\Entities\Banner;
use Modules\Category\Entities\Category;
use Modules\Menu\Entities\Menu;
use Modules\Setting\Entities\Setting;

class ComposerServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        view()->composer('admin*', function (View $view) {
            $user = auth()->user();
            $user_roles_array = $user->roles()->pluck('display_name');
            $user_roles = '';

            foreach($user_roles_array as $index => $role){
                $user_roles .= $role;
                ($index < count($user_roles_array) -1)?$user_roles .= ', ' : '';
            }

            $menus = \App\MenuFactory::build();

            $settings = Setting::where(['autoload' => 1])->pluck('value', 'key')->all();

            $params = [
                'user_roles'    => $user_roles,
                'loggedin_user' => $user,
                'menus'         => $menus,
                'site_settings' => $settings,
            ];

            $view->with($params);
        });
        view()->composer('admin.layouts*', function (View $view) {
            $userPermissions = \App\MenuFactory::userPermissions();

            $view->with(['userPermissions' => $userPermissions]);
        });
        view()->composer('frontend*', function (View $view) {
            $params['loggedin_user'] = auth()->user();
            $params['site_settings'] = Setting::autoload()->pluck('value', 'key')->toArray();
            $view->with($params);
        });
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
