<?php

namespace App\Providers;

use App\Events\VerificationCodeRequested;
use App\Listeners\SetDefaultRole;
use App\Listeners\SetDefaultTwoFactor;
use App\Listeners\SendMobileVerificationCode;
use Illuminate\Auth\Events\Registered;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SetDefaultRole::class,
            SetDefaultTwoFactor::class,
            SendMobileVerificationCode::class,
        ],
        Login::class => [
//            SetTwoFactorUnverified::class,
        ],
        VerificationCodeRequested::class => [
            SendMobileVerificationCode::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
