<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['standard', 'inspector', 'manufacturer'])->default('standard');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('mobile')->unique();
            $table->string('phone');
            $table->string('email');
            $table->string('password');
            $table->string('national_code');
            $table->string('economic_code')->nullable();
            $table->string('connector_first_name')->nullable();
            $table->string('connector_last_name')->nullable();
            $table->string('connector_national_code')->nullable();
            $table->tinyInteger('two_factor_activated');
            $table->timestamp('two_factor_verified_at')->nullable();
            $table->timestamp('email_verified_at')->nullable();

            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
