@extends('admin.layouts.app')
@section('content')
    <div class="row">
        <!-- Left col -->
        <section class="col-lg-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">لیست دسترسی های تعریف شده</h3>
                </div>
                <div class="content">
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs">
                            @foreach($roles as $index => $role)
                                <li class="{{$role->name=='admin'?'active':''}}"><a href="#tab_{{$index}}" data-toggle="tab" aria-expanded="false">{{ $role->display_name }}</a></li>
                            @endforeach
                        </ul>
                        <div class="tab-content">
                            @foreach($roles as $index => $role)
                                <div class="tab-pane {{$role->name=='admin'?'active':''}}" id="tab_{{$index}}">
                                    <a href="{{ route('admin.permissions.edit', ['id' => $role->id]) }}" class="btn btn-info pull-right">کنترل سطح دسترسی</a>
                                    <p>دسترسی های  <b>{{$role->display_name}}</b></p>
                                    <ul>
                                        @foreach($role->permissions as $permission)
                                            <li>{{ $permission->display_name }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                        @endforeach
                        <!-- /.tab-pane -->
                        </div>
                        <!-- /.tab-content -->
                    </div>
                </div>
            </div>

        </section>
        <!-- /.Left col -->
    </div>
@endsection
