@extends('admin.layouts.app')

@section('styles')
@endsection

@section('scripts')

@endsection

@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">ویرایش تنظیمات</h3>

                    <div class="box-tools">
                        <div class="input-group input-group-sm">
                            <a href="{{ route('admin.settings.index') }}" class="btn btn-default btn-sm">لیست تنظیمات
                                <span class="fa fa-arrow-left"></span>
                            </a>
                        </div>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <form method="post" action="{{ route('admin.settings.update', $setting->id) }}" role="form" class="form-horizontal">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label for="value" class="col-md-2 control-label">{{ $setting->label }}</label>
                            @if($setting->type=='file')
                                <div class="col-md-10">
                                    <input type="file" name="value" id="value" class="form-control">
                                    <a href="{{ asset($setting->value) }}" target="_blank">مشاهده</a>
                                </div>
                            @else
                                <div class="col-md-10">
                                    <textarea name="value" id="value" class="form-control {{ $setting->type=='editor' ? 'tinymce' : '' }}" rows="5">{{ old('value', $setting->value) }}</textarea>
                                </div>
                            @endif
                        </div>
                        <input type="submit" class="btn btn-primary" value="ذخیره تغییرات">
                    </form>
                </div>
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
        </div>
    </div>
    <!-- /.row -->
@endsection
