@extends('frontend.layouts.app')

@section('title', 'ثبت‌نام')

@section('styles')
    <link rel="stylesheet" href="{{ asset('css/account.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/select2/select2.min.css') }}">
    <style>
        .select2-selection__choice {
            color: #666 !important;
        }

        .select2-container {
            width: 100% !important;
        }

        .select2-search__field {
            width: 100% !important;
        }
    </style>
@endsection

@section('scripts')
@endsection

@section('content')

    <div class="container-fluid body-section">
        <div class="container">
            <div class="row my-5">
                <div class="col col-12 col-md-6 col-lg-5 mx-auto">
                    <div class="card card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <form class="form-login-out" id="account" method="POST" action="{{ route('register') }}">
                            @csrf
                            <div class="inbox-form">
                                <h3 class="title-box text-center font-weight-bold position-relative">ثبت‌نام</h3>
                                <br>
                                <div class="form-group mb-3">
                                    <label for="first_name" class="mb-1">نام</label>
                                    <input type="text" name="first_name" class="form-control" id="first_name" value="{{ old('first_name') }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="last_name" class="mb-1">نام خانوادگی</label>
                                    <input type="text" name="last_name" class="form-control" id="last_name" value="{{ old('last_name') }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="mobile" class="mb-1">شماره همراه </label>
                                    <input type="text" name="mobile" class="form-control" id="mobile" value="{{ old('mobile') }}" maxlength="11">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="password" class="mb-1">رمزعبور</label>
                                    <input type="password" name="password" class="form-control" id="password" value="">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="password_confirmation" class="mb-1">تایید رمزعبور</label>
                                    <input type="password" name="password_confirmation" class="form-control" id="password_confirmation" value="">
                                </div>
                                <div class="row">
                                    <div class="col col-md-12 col-lg-12 col-12 p-0 mt-4">
                                        <button type="submit" class="btn btn-success form-control">
                                            <i class="reg-icon"></i>
                                            <span class="txt-btn-reg">ثبت نام در سایت</span>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col col-md-12 col-lg-12 col-12">
                                        <div class="modal-footer">
                                            <div class="col col-md-12 col-lg-12 col-12 text-center">
                                                <span class="txt-register">اگر قبلا ثبت نام کرده‌ايد، لطفا وارد شويد</span>
                                                <span class="link-register">
                                                    <a target="_blank" href="{{ route('login') }}">ورود به سایت</a>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
