@extends('frontend.layouts.app')
@section('title', 'تایید شماره موبایل')
@section('styles')
    <link rel="stylesheet" href="{{ asset('css/font-awesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/account.css') }}">
@endsection

@section('scripts')

@endsection

@section('content')
    <div class="container">
        <div class="row justify-content-center py-5 mb-5">
            <div class="col-md-6 col-sm-12">
                <div class="panel panel-default twofa-card">
                    <div class="panel-heading">
                        <h3 class="panel-title text-center mb-5">تایید شماره موبایل</h3>
                    </div>
                    <div class="panel-body">
                        <p class="text-center mb-4">کد ارسال شده به موبایل خود را وارد کنید، اعتبار کد تنها 15 دقیقه می‌باشد.</p>
                        <form action="{{ route('twoFactor.verification') }}" method="post">
                            @csrf
                            <div class="row mb-3 justify-content-center">
                                <div class="align-self-center">
                                    <label for="code">کد تایید</label>
                                </div>
                                <div class="col col-md-12">
                                    <input id="code" type="text" class="form-control{{ $errors->has('code') ? ' is-invalid' : '' }}" name="code" value="{{ old('code') }}" required dir="ltr" size="4">
                                    @if ($errors->has('code'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('code') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="row mb-0">
                                <div class="col-md-12">
                                    <button type="submit" class="btn-success w-100 rounded btn btn-block">تایید</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="panel-footer">
                        <form action="{{ route('twoFactor.resendVerification') }}" method="post">
                            @csrf
                            <button type="submit" class="btn btn-link btn-warning text-light">ارسال مجدد کد</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection