<?php $__env->startSection('styles'); ?>
    <style>
        .field-password-icon {
            z-index: 3;
            position: absolute;
            left: 10px;
            margin-top: 9px;
            cursor: pointer;
        }
        .field-otp-password-icon {
            z-index: 3;
            position: relative;
            left: 25px;
            margin-top: 9px;
            cursor: pointer;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title', 'ورود'); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(".toggle-password").click(function() {
            $(this).toggleClass("fa-eye fa-eye-slash");
            if ($('#password').attr("type") == "password") {
                $('#password').attr("type", "text");
            }
            else {
                $('#password').attr("type", "password");
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid body-section">
        <div class="container">
            <div class="row my-5">
                <div class="col col-12 col-md-6 col-lg-5 mx-auto">
                    <div class="card card-body">
                        <form class="form-login-out" method="POST" action="<?php echo e(route('login')); ?>" enctype="multipart/form-data" id="login-form">
                            <?php echo csrf_field(); ?>
                            <div class="inbox-form">
                                <h3 class="title-box text-center font-weight-bold position-relative"> ورود به سایت</h3>
                                <br>
                                <?php if($errors->any()): ?>
                                    <div class="alert alert-danger">
                                        <ul>
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                                <div class="form-group">
                                    <label for="mobile" class="mb-2">شماره موبایل</label>
                                    <input type="text" name="mobile" class="form-control" id="mobile" value="<?php echo e(old('mobile')); ?>" maxlength="11" autofocus>
                                    <?php if($errors->has('mobile')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('mobile')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="form-group">
                                    <label for="password" class="mb-2">رمزعبور</label>
                                    <div class="input-group">
                                        <input type="password" name="password" class="form-control" id="password" value="">
                                        <span toggle="#password-field" class="fa fa-fw fa-eye field-password-icon toggle-password"></span>
                                        <?php if($errors->has('password')): ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('password')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="form-check mt-3 mb-2">
                                    <input type="checkbox" class="form-check-input" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="remember">مرا به خاطر بسپار</label>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary form-control">
                                        <i class="login-icon"></i>
                                        <span class="txt-btn-reg">ورود به سایت</span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\nonegar\Panel\resources\views/auth/login.blade.php ENDPATH**/ ?>