<?php
include_once '../classes/jdf.php';
require_once "checklogin.php";
require_once "../classes/invoice.php";
require_once "../classes/user.php";

$invoice = new Invoice();
$user = new User();
$result = $invoice->getOne($_GET['id']);
?>
<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>
    <meta charset="utf-8"/>
    <title>صورتحساب | دیجی گیفت </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description"/>
    <meta content="Coderthemes" name="author"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- App css -->
    <link href="assets/css/config/default/bootstrap-rtl.min.css" rel="stylesheet" type="text/css"
          id="bs-default-stylesheet"/>
    <link href="assets/css/config/default/app-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-default-stylesheet"/>

    <link href="assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css"
          id="bs-dark-stylesheet" disabled="disabled"/>
    <link href="assets/css/config/default/app-dark-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-dark-stylesheet" disabled="disabled"/>

    <!-- icons -->
    <link href="assets/css/icons-rtl.min.css" rel="stylesheet" type="text/css"/>

</head>

<!-- body start -->
<body class="loading"
      data-layout='{"mode": "light", "width": "fluid", "menuPosition": "fixed", "sidebar": { "color": "light", "size": "default", "showuser": true}, "topbar": {"color": "light"}, "showRightSidebarOnPageLoad": true}'>

<!-- Begin page -->
<div id="wrapper">

    <!-- Topbar Start -->
    <?php include_once "tobbar.php"; ?>
    <!-- end Topbar -->
    <!-- ========== Left Sidebar Start ========== -->
    <?php include_once "sidebar.php"; ?>
    <!-- Left Sidebar End -->
    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="panel-body">
                                    <div class="clearfix">

                                        <div class="float-end">
                                            <h4>صورتحساب <br>
                                                <strong></br>
                                                    <?= jstrftime('%Y/%m/%e', $result['created_at']) ?>
                                                </strong>
                                            </h4>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="float-start mt-3">
                                                <address>
                                                    <strong>DigitGift</strong><br>
                                                    <br>
تهران<br>
                                                  
                                                    <abbr title="Phone">تلفن:<abbr>0211234567

                                                </address>
                                            </div>
                                            <div class="float-end mt-3">

                                                <p><strong>تاریخ سفارش : </strong>
                                                
                                                <?= jstrftime('%Y/%m/%e ,%A', $result['created_at']) ?>
                                                </p>
                                                <p class="m-t-10"><strong>وضعیت سفارش: </strong> <span
                                                            class="label label-pink">
                                                        <?php if ($result['st'] == 1) { ?>
                                                            <span class="badge badge-outline-success"> پرداخت شده</span>
                                                        <?php } else { ?>
                                                            <span class="badge badge-outline-danger"> پرداخت نشده</span>
                                                        <?php } ?>
                                                    </span></p>

                                                <p class="m-t-10"><strong>شناسه سفارش: </strong>    #
                                                
                                                 <?= $result['id'] ?>
                                                </p>
                                            </div>
                                        </div><!-- end col -->
                                    </div>
                                    <!-- end row -->

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="table-responsive">
                                                <table class="table mt-4">
                                                    <thead>
                                                    <tr>
                                                        <th>شناسه سفارش</th>
                                                        <th> موبایل کاربر</th>
                                                        <th> نام کاربر </th>
                                                        <th> تاریخ ثبت</th>
                                                        <th>تاریخ پرداخت </th>
                                                        <th> درگاه </th>
                                                    </tr>
                                                    </thead>
                                                    
                                                    <tbody>
                                                    <tr>
                                                    <td> <?= $result['id'] ?> </td>
                                                    <td> <?php
                                                    $userinfo = $user->getOne($result['userid']);
                                                    echo $userinfo['phone'];
                                                    ?>
                                                    </td>
                                                    <td> <?php
                                                    $userinfo = $user->getOne($result['userid']);
                                                    echo $userinfo['name'];
                                                    ?>
                                                    </td>
                                                    <td>  <?= jstrftime('%Y/%m/%e ,%A', $result['created_at']) ?></td>
                                                    <td> <?= $result['paid_at'] != '' ? jstrftime('%H:%M:%S - %Y/%m/%e', $result['paid_at']) : '' ?></td>
                                                    <td> <?= $result['gateway'] ?></td>
                                                    </tr>                                               
                                                    </tbody>
                                                    
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-6 col-6">
                                            <div class="clearfix mt-4">
                                                <h5 class="small text-dark fw-normal"> دپارتمان مالی </h5>

                                                <small>
                                                    دیجیت پی

                                                    هر آنچه برای کسب درآمد در دنیای دیجیتال نیاز دارید!
                                                </small>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-6 offset-xl-3">
                                            <p class="text-end"><b>مبلغ
                                                    کل:</b>تومان
                                                    <?= number_format($result['amount']) ?>
                                            </p>
                                            <hr>
                                        </div>
                                       <div class="row">
                                        <div class="col-md-12">
                                            <div class="table-responsive">
                                                <table class="table mt-4">
                                                    <thead>
                                                    <tr>
                                                        <th> کد پیگیری</th>
                                                        <th>کد رهگیری </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td><?= $result['refid'] ?> </td>
                                                        <td><?= $result['resid'] ?></td>
                                                    </tr>
                                                   
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="d-print-none">
                                        <div class="float-end">
                                            <a href="javascript:window.print()"
                                               class="btn btn-bordered-success waves-effect waves-light"><i class="fa fa-print"></i></a>

                                            <!--                                            <a href="#"-->
                                            <!--                                               type="submit" name="submit"-->
                                            <!--                                               class="btn btn-primary waves-effect waves-light">تایید</a>-->

                                        </div>

                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
                <!-- end row -->

            </div> <!-- container-fluid -->

        </div> <!-- content -->

        <!-- Footer Start -->
  <?php include_once "footer.php"; ?>
        <!-- end Footer -->

    </div>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->


<!-- Right bar overlay-->
<div class="rightbar-overlay"></div>

<!-- Vendor js -->
<script src="assets/js/vendor.min.js"></script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>

</body>
</html>