<?php
require_once "checklogin.php";
include_once '../classes/db.php';
include_once '../classes/gateway.php';


$gateway = new Gateway();
$id = isset($_GET['id']) ? $_GET['id'] : '';
$result = [];
$msg = '';
$msgok = '';

$name = isset($_POST['name']) ? $_POST['name'] : '';
$title = isset($_POST['title']) ? $_POST['title'] : '';
$st = isset($_POST['st']) ? 1 : 0;
$apikey = isset($_POST['apikey']) ? $_POST['apikey'] : '';


if (isset($_GET['action']) && $_GET['action'] == "edit" && !isset($_POST['submit'])) {
    $result = $gateway->getOne($id);
    if ($result == [])
        die('خطای دسترسی غیر مجاز');
    $name = $result['name'];
    $title = $result['title'];
    $st = $result['st'];
    $apikey = $result['apikey'];
}

if (isset($_POST['submit'])) {

    $gateway->setTitle($title);
    $gateway->setApikey($apikey);
    $gateway->setSt($st);

    if (isset($_GET['action']) && $_GET['action'] == "edit") {

        $gateway->UpdateData($id);
        header('location:gateway.php?update=success');
    }
}

?>

<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>

    <meta charset="utf-8"/>
    <title>ویرایش درگاه</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description"/>
    <meta content="Coderthemes" name="author"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">
    <link href="assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css"/>

    <!-- App css -->
    <link href="assets/css/config/default/bootstrap-rtl.min.css" rel="stylesheet" type="text/css"
          id="bs-default-stylesheet"/>
    <link href="assets/css/config/default/app-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-default-stylesheet"/>

    <link href="assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css"
          id="bs-dark-stylesheet" disabled="disabled"/>
    <link href="assets/css/config/default/app-dark-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-dark-stylesheet" disabled="disabled"/>

    <!-- icons -->
    <link href="assets/css/icons-rtl.min.css" rel="stylesheet" type="text/css"/>

</head>

<!-- body start -->
<body class="loading"
      data-layout='{"mode": "light", "width": "fluid", "menuPosition": "fixed", "sidebar": { "color": "light", "size": "default", "showuser": true}, "topbar": {"color": "light"}, "showRightSidebarOnPageLoad": true}'>
<!-- Begin page -->
<div id="wrapper">
    <!-- Topbar Start -->
    <?php include_once "tobbar.php"; ?>
    <!-- end Topbar -->

    <!-- ========== Left Sidebar Start ========== -->
    <?php include_once "sidebar.php"; ?>
    <!-- Left Sidebar End -->
    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">
            <!-- Start Content-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 id="title" class="header-title">فرم اطلاعات درگاه</h4>
                                <p class="sub-header">
                                    لطفا برای ویرایش , اطلاعات درگاه را وارد کرده و در نهایت کلید ذخیره را فشار دهید
                                </p>
                                <div class="row">
                                    <?php
                                    if ($msg != '') {
                                        ?>
                                        <div class="alert alert-warning alert-dismissible fade show"
                                             style="margin-top: 15px" role="alert">
                                            <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                    aria-label="Close"></button>
                                            <?php
                                            echo $msg;
                                            ?>
                                        </div>
                                        <?php
                                    }

                                    if ($msgok != '') {
                                        ?>
                                        <div class="alert alert-success alert-dismissible fade show"
                                             style="margin-top: 15px" role="alert">
                                            <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                    aria-label="Close"></button>
                                            <?php
                                            echo $msgok;
                                            ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                    <form method="post" enctype="multipart/form-data" class="needs-validation"
                                          novalidate>
                                        <div class="row">
                                         
                                            <div class="col-xl-6 col-lg-6  col-xs-12 col-sm-12">
                                                <label for="title" class="form-label">عنوان درگاه</label>
                                                <input type="text" id="title" name="title" class="form-control"
                                                       value="<?= $title ?>"
                                                       placeholder="عنوان درگاه را وارد کنید" required>
                                                <div class="valid-feedback">
                                                    بنظر درست میاد
                                                </div>
                                                <div class="invalid-feedback">
                                                    لطفا بصورت درست وارد کنید
                                                </div>
                                            </div>
                                             <div class="col-xl-6 col-lg-6  col-xs-12 col-sm-12">
                                                <label for="apikey" class="form-label">کلید API</label>
                                                <input type="text" id="apikey" name="apikey" class="form-control"
                                                       value="<?= $apikey ?>"
                                                       placeholder=" کلید را وارد کنید" required>
                                                <div class="valid-feedback">
                                                    بنظر درست میاد
                                                </div>
                                                <div class="invalid-feedback">
                                                    لطفا بصورت درست وارد کنید
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-3 col-lg-3 col-md-3 col-xs-12 col-sm-12">
                                                <div class="form-check mb-3 form-check-primary">
                                                    <input class="form-check-input" name="st" type="checkbox"
                                                            value="1"
                                                           <?php if ($st == 1) {
                                                               echo "checked=checked";
                                                           } ?>

                                                           id="customckeck1">
                                                    <label class="form-check-label"
                                                           for="customckeck1">فعال</label>
                                                </div>
                                            </div>

                                        </div>
                                        <?php
                                        if (isset($_GET['action']) && $_GET['action'] == "edit") {
                                            ?>
                                            <button type="submit" name="submit"
                                                    class="btn btn-success waves-effect waves-light">ذخیره
                                            </button>
                                        <?php } ?>


                                        <!-- end col -->
                                    </form>
                                    <!-- end row-->

                                </div> <!-- end card-body -->
                            </div> <!-- end card -->
                        </div><!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->


            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


            <!-- Footer Start -->
            <?php include_once "footer.php"; ?>
            <!-- end Footer -->

        </div>
        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right Sidebar -->
    <?php include_once "rsidebar.php"; ?>
    <!-- /Right-bar -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- knob plugin -->
    <script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>

    <!--Morris Chart-->
    <script src="assets/libs/morris.js06/morris.min.js"></script>
    <script src="assets/libs/raphael/raphael.min.js"></script>

    <!-- Dashboar init js-->
    <!--<script src="assets/js/pages/dashboard.init.js"></script>-->

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>
    <script src="assets/libs/mohithg-switchery/switchery.min.js"></script>
    <!--    <script>-->
    <!--        $('#title').text('mahsaakifhiugdfiugilfughf');-->
    <!--        alert('slmmmmm')-->
    <!--    </script>-->
</body>
</html>