<?php
include_once 'classes/db.php';
include_once 'classes/user.php';
include_once 'classes/invoice.php';
include_once 'classes/gateway.php';

if ((!isset($_POST['secret'])) || ($_POST['secret'] != SECRET)) {
    $msg = [
        "st" => false,
        "msg" => "دسترسی غیر مجاز",
    ];
} else {
    if (isset($_POST['action']) && $_POST['action'] == 'req') {
        $user = new User();
        $name = '';
        $mobile = isset($_POST['mobile']) ? $_POST['mobile'] : '';
        $amount = isset($_POST['amount']) ? $_POST['amount'] : '';
        $url = isset($_POST['callbackurl']) ? $_POST['callbackurl'] : '';
        $st = 0;
        $codemeli = '';

        if (strlen($mobile) == 11) {
            if (is_numeric($amount) && $amount > 1000) {
                if ($url!='') {
                    try {
                        $user->setName($name);
                        $user->setPhone($mobile);
                        $user->setCodeMeli($codemeli);
                        $user->setSt($st);

                        $fres = $user->existMobile($mobile);
                        $userid = $fres == false ? $user->insertData() : $fres;

                        if (is_numeric($userid)) {
                            $invoice = new Invoice();
                            $invoice->setUserid($userid);
                            $invoice->setCallbackurl($url);
                            
                            $gateway = new Gateway();
                            $DefultGateway = $gateway->getDefultGateway();
                            $invoice->setGateway($DefultGateway["name"]);
                            
                            
                            $invoice->setAmount($amount);
                            $invoiceid = $invoice->insertData();

                            $msg = is_numeric($invoiceid) ? ["st" => true, "msg" => $invoiceid, "payment_url" => SYSTEM_URL."/pay.php?id=" . $invoiceid] : ["st" => false, "msg" => "خطایی به وجود آمده است"];
                        } else {
                            $msg = [
                                "st" => false,
                                "msg" => "خطایی به وجود آمده است",
                            ];
                        }
                    } catch (Exception $e) {
                        $msg = [
                            "st" => false,
                            "msg" => "خطایی به وجود آمده است",
                        ];
                    }
                } else {
                    $msg = [
                        "st" => false,
                        "msg" => "ادرس کال بک را به درستی وارد کنید",
                    ];
                }
            } else {
                $msg = [
                    "st" => false,
                    "msg" => "مبلغ را به درستی و بیشتر از ۱۰۰۰ تومان وارد کنید",
                ];
            }
        } else {
            $msg = [
                "st" => false,
                "msg" => "لطفا موبایل خود را وارد کنید",
            ];
        }
    } elseif (isset($_POST['action']) && $_POST['action'] == 'verify') {
        $invoiceId = isset($_POST['invoiceId']) ? $_POST['invoiceId'] : '';
        $invoice = new Invoice();
        $invoiceInfo = $invoice->getOne($invoiceId);

        if ($invoiceInfo != false) {
            $msg = [
                "st" => true,
                "msg" => [
                    "st" => $invoiceInfo["st"],
                    "paid_at" => $invoiceInfo["paid_at"],
                    "refid" => $invoiceInfo["refid"],
                    "resid" => $invoiceInfo["resid"],
                ],
            ];
        } else {
            $msg = [
                "st" => false,
                "msg" => "خطایی به وجود آمده است",
            ];
        }
    }
}

header('Content-type: application/json; charset=utf-8');
echo json_encode($msg);
