<?php
require_once 'db.php';
require_once 'base.php';
require_once 'class-logs.php';


class Admin extends Base
{

    private $name;
    private $username;
    private $email;
    private $password;
    private $avatar;

    public function __construct()
    {
        $this->table = 'admin';
    }

    public function setName($name)
    {

        $this->name = $name;
    }

    public function setUsername($username)
    {
        $this->username = $username;
    }

    public function setEmail($email)
    {
        $this->email = $email;
    }

    public function setPass($password)
    {
        $this->password = $password;
    }
    public function setAvatar($avatar)
    {
        $this->avatar=$avatar;
    }

    public function login()
    {
        $sql = "SELECT * FROM  $this->table WHERE email=:email";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":email", $this->email);
        $stat->execute();
        $result = $stat->fetch();
        if (isset($result['id'])) {
        $pass=hash_hmac("sha256", $this->password, "0N4IzzuT4hHAg06NIlYQP6tBeMDXy6Vq8PEkDCh28lERFqxqop");
         return (password_verify($pass,$result['password']))  ? ["st"=>true,"msg"=>$result] : ["st"=>false,"msg"=>"اطلاعات ورود اشتباه می باشد"];
        }
        else return ["st"=>false,"msg"=>"این ایمیل یافت نشد"];
         
    }

    public function insertData()
    {
        $sql = "INSERT INTO $this->table(name,username,email,password,avatar) VALUES(:name,:username,:email,:password,:avatar)";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":name", $this->name);
        $stat->bindParam(":username", $this->username);
        $stat->bindParam(":email", $this->email);
        $stat->bindParam(":password", password_hash(hash_hmac("sha256", $this->password, "0N4IzzuT4hHAg06NIlYQP6tBeMDXy6Vq8PEkDCh28lERFqxqop"), PASSWORD_DEFAULT));
        $stat->bindParam(":avatar", $this->avatar);
        $log = new Logs();
        $log->setcContent('افزودن ادمین جدید');
        $log->insertData();
        return $stat->execute();
    }

    public function UpdateData($id)
    {
        $sql = "UPDATE $this->table SET name=:name,username=:username,email=:email WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":name", $this->name);
        $stat->bindParam(":username", $this->username);
        $stat->bindParam(":email", $this->email);
        $stat->bindParam(":id", $id);
        $log = new Logs();
        $log->setcContent('ویرایش اطلاعات ادمین' . ' ' . $id);
        $log->insertData();
        return $stat->execute();
    }
      public function ChangePassword($id)
    {
        $sql = "UPDATE $this->table SET password=:password WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":password", password_hash(hash_hmac("sha256", $this->password, "0N4IzzuT4hHAg06NIlYQP6tBeMDXy6Vq8PEkDCh28lERFqxqop"), PASSWORD_DEFAULT));
        $stat->bindParam(":id", $id);
        return $stat->execute();
    }
    

    public function existField($fieldname, $fieldvalue, $id)
    {
        $sql = "SELECT * FROM admin WHERE " . $fieldname . "=:field  AND id!=:id  ";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":field", $fieldvalue);
        $stat->bindParam(":id", $id);
        $stat->execute();
        $result = $stat->fetchAll();
        return (count($result) > 0) ? true : false;

    }

}