<?php
require_once 'db.php';

class Base
{

    protected $table;

    public function getOne($id)
    {
        $sql = "SELECT * FROM $this->table WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":id", $id);
        $stat->execute();
        return $stat->fetch();
    }
    public function deleteData($id)
    {
        $sql = "DELETE FROM $this->table WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(':id', $id);
        return $stat->execute();
    }

    public function viewAll($count=0,$sort='desc')
    {
         if ($count!=0){
             $sql = "SELECT * FROM $this->table ". ' order by id '.$sort .' LIMIT 0, '.$count ;
         } else {
             $sql = "SELECT * FROM $this->table ";
         }
        $stat = DB::prepareOwm($sql);
        $stat->execute();
        return $stat->fetchAll();
    }

}