<?php

include_once 'conf.db.php';
class DB {
    private $Host;
    private $DBName;
    private $DBUser;
    private $DBPassword;
    private $DBPort;
    private $pdo;
    private $sQuery;
    private $bConnected = false;
    private $log;
    private $parameters;
    public $rowCount = 0;
    public $columnCount = 0;
    public $querycount = 0;
    public function __construct($Host = DB_HOST, $DBName = DB_NAME, $DBUser = DB_USER, $DBPassword = DB_PASS, $DBPort = 3306) {

        $this->Host = $Host;
        $this->DBName = $DBName;
        $this->DBUser = $DBUser;
        $this->DBPassword = $DBPassword;
        $this->DBPort = $DBPort;
        $this->Connect();
        $this->parameters = [];
    }
    public function multipleInsert($table, $data = []) {
        try {
            $pdo = new PDO('mysql:dbname=' . $this->DBName . ';host=' . $this->Host . ';port=3306;charset=utf8', $this->DBUser, $this->DBPassword, array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8", PDO::ATTR_EMULATE_PREPARES => false,
            //PDO::ATTR_PERSISTENT => true,
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,));
            $this->bConnected = true;
        }
        catch(PDOException $e) {
            echo $this->ExceptionLog($e->getMessage());
            die();
        }
        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);
        # INSERT (name) VALUE (value),(value)
        if (count($data) > 1) {
            $fieldnames = array_keys($data[0]);
            $count_inserts = count(array_values($data));
            $count_values = count(array_values($data[0]));
            # array(????) untill x from first data
            for ($i = 0;$i < $count_values;$i++) {
                $placeholder[] = '?';
            }
            # array((????),(????),(????)) for query
            for ($i = 0;$i < $count_inserts;$i++) {
                $placeholders[] = '(' . implode(',', $placeholder) . ')';
            }
            $query = 'INSERT INTO ' . $table;
            $query.= '(`' . implode('`, `', $fieldnames) . '`)';
            $query.= ' VALUES ' . implode(', ', $placeholders);
            $insert = $pdo->prepare($query);
            $i = 1;
            foreach ($data as $item) {
                foreach ($item as $key => $value) {
                    $insert->bindValue($i++, en_digits($item[$key]));
                }
            }
            $insert->execute();
            return true;
        } else {
            die('$data is less then two array, use single insert instead.');
        }
    }
    private function Connect() {
        try {
            $this->pdo = new PDO('mysql:dbname=' . $this->DBName . ';host=' . $this->Host . ';port=' . $this->DBPort . ';charset=utf8', $this->DBUser, $this->DBPassword, array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8", PDO::ATTR_EMULATE_PREPARES => false,
            //PDO::ATTR_PERSISTENT => true,
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,));
            $this->bConnected = true;
        }
        catch(PDOException $e) {
            echo $this->ExceptionLog($e->getMessage());
            die();
        }
    }
    public function CloseConnection() {
        $this->pdo = null;
    }
    private function Init($query, $parameters = "") {
        if (!$this->bConnected) {
            $this->Connect();
        }
        try {
            $this->parameters = $parameters;
            $this->sQuery = $this->pdo->prepare($this->BuildParams($query, $this->parameters));
            if (!empty($this->parameters)) {
                if (array_key_exists(0, $parameters)) {
                    $parametersType = true;
                    array_unshift($this->parameters, "");
                    unset($this->parameters[0]);
                } else {
                    $parametersType = false;
                }
                foreach ($this->parameters as $column => $value) {
                    $this->sQuery->bindParam($parametersType ? intval($column) : ":" . $column, $this->parameters[$column]); //It would be query after loop end(before 'sQuery->execute()').It is wrong to use $value.
                    
                }
            }
            $this->succes = $this->sQuery->execute();
            $this->querycount++;
        }
        catch(PDOException $e) {
            echo $this->ExceptionLog($e->getMessage(), $this->BuildParams($query));
            die();
        }
        $this->parameters = [];
    }
    private function BuildParams($query, $params = []) {
        if (!empty($params)) {
            $array_parameter_found = false;
            foreach ($params as $parameter_key => $parameter) {
                if (is_array($parameter)) {
                    $array_parameter_found = true;
                    $in = "";
                    foreach ($parameter as $key => $value) {
                        $name_placeholder = $parameter_key . "_" . $key;
                        $in.= ":" . $name_placeholder . ", ";
                        $params[$name_placeholder] = $value;
                    }
                    $in = rtrim($in, ", ");
                    $query = preg_replace("/:" . $parameter_key . "/", $in, $query);
                    unset($params[$parameter_key]);
                }
            }
            if ($array_parameter_found) {
                $this->parameters = $params;
            }
        }
        return $query;
    }
    public function query($query, $params = null, $fetchmode = PDO::FETCH_ASSOC) {
        $query = trim($query);
        $rawStatement = explode(" ", $query);
        $this->Init($query, $params);
        $statement = strtolower($rawStatement[0]);
        if ($statement === 'select' || $statement === 'show') {
            return $this->sQuery->fetchAll($fetchmode);
        } elseif ($statement === 'insert' || $statement === 'update' || $statement === 'delete') {
            return $this->sQuery->rowCount();
        } else {
            return null;
        }
    }
    public function lastInsertId() {
        return $this->pdo->lastInsertId();
    }
    public function column($query, $params = null) {
        $this->Init($query, $params);
        $resultColumn = $this->sQuery->fetchAll(PDO::FETCH_COLUMN);
        $this->rowCount = $this->sQuery->rowCount();
        $this->columnCount = $this->sQuery->columnCount();
        $this->sQuery->closeCursor();
        return $resultColumn;
    }
    public function row($query, $params = null, $fetchmode = PDO::FETCH_ASSOC) {
        $this->Init($query, $params);
        $resultRow = $this->sQuery->fetch($fetchmode);
        $this->rowCount = $this->sQuery->rowCount();
        $this->columnCount = $this->sQuery->columnCount();
        $this->sQuery->closeCursor();
        return $resultRow;
    }
    public function GetRowCount() {
        return $this->rowCount;
    }
    public function single($query, $params = null) {
        $this->Init($query, $params);
        return $this->sQuery->fetchColumn();
    }
    private function ExceptionLog($message, $sql = "") {
        $exception = 'Unhandled Exception. <br />';
        $exception.= $message;
        $exception.= "<br /> You can find the error back in the log.";
        if (!empty($sql)) {
            $message.= "\r\nRaw SQL : " . $sql;
        }
        header("HTTP/1.1 500 Internal Server Error");
        header("Status: 500 Internal Server Error");
        return $exception;
    }
}
