<?php
require_once 'db.php';
require_once 'base.php';
require_once 'class-logs.php';


class Gateway extends Base
{
    private $name;
    private $title;
    private $st;
    private $apikey;


    public function __construct()
    {
        $this->table = 'gateway';
    }

    public function setName($name)
    {

        $this->name = $name;
    }

    public function setTitle($title)
    {
        $this->title = $title;
    }

    public function setSt($st)
    {
        $this->st = $st;
    }

    public function setApikey($apikey)
    {
        $this->apikey = $apikey;
    }

   public function UpdateData($id)
    {
        $sql = "UPDATE $this->table SET apikey=:apikey,title=:title,st=:st WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $default_gateway=1;
        $stat->bindParam(":apikey", $this->apikey);
        $stat->bindParam(":title", $this->title);
        $stat->bindParam(":st", $this->st);
        $stat->bindParam(":id", $id);
        $log = new Logs();
        $log->setcContent('ویرایش اطلاعات درگاه' . ' ' . $id);
        $log->insertData();
        return $stat->execute();
    }
    public function defaultGateway($id)
    {
        $sql = "UPDATE $this->table SET default_gateway=:default_gateway WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $default_gateway=1;
        $stat->bindParam(":default_gateway", $default_gateway);
        $stat->bindParam(":id", $id);
        $log = new Logs();
        $log->setcContent('ویرایش اطلاعات درگاه' . ' ' . $id);
        $log->insertData();
        return $stat->execute();
    }

public function getDefultGateway()
    {
        $sql = "SELECT * FROM gateway WHERE default_gateway=:default_gateway and  st=:st";
        $stat = DB::prepareOwm($sql);
        $default_gateway=1;
        $st=1;
        $stat->bindParam(":default_gateway", $default_gateway);
        $stat->bindParam(":st", $st);
        $stat->execute();
        $result = $stat->fetch();
        return ($result==false) ? false : $result;

    }
      public function UndefaultGateway()
    {
        $sql = "UPDATE $this->table SET default_gateway=:default_gateway WHERE default_gateway=1";
        $stat = DB::prepareOwm($sql);
        $default_gateway=0;
        $stat->bindParam(":default_gateway", $default_gateway);
        return $stat->execute();
    }
    
    public function deleteData($id)
    {
        $result = $this->countOrder($id);
        $user = $this->getOne($id);
        if ($result == 0) {
            $sql = "DELETE FROM $this->table WHERE id=:id";
            $stat = DB::prepareOwm($sql);
            $stat->bindParam(':id', $id);
            $status = $stat->execute();
            return $status;
        } else
            throw new Exception("درگاهی که فعال است است امکان حذف ندارد");
    }


}

