<?php
require_once 'db.php';
require_once 'base.php';
require_once 'user.php';
require_once 'class-logs.php';


class Invoice extends Base
{
    private $userid;
    private $amount;
    private $callbackurl;
    private $gateway;
    private $st;
    private $time;

    public function __construct()
    {
        $this->table = 'invoice';
    }

    public function setUserid($userid)
    {
        $this->userid = $userid;
    }

  public function setCallbackurl($callbackurl)
    {
        $this->callbackurl = $callbackurl;
    }
    
      public function setGateway($gateway)
    {
        $this->gateway = $gateway;
    }
    
    public function setSt($st)
    {
        $this->st = $st;
    }

     
    public function setAmount($amount)
    {
        $this->amount = $amount;
    }

    public function insertData()
    {
        $sql = "INSERT INTO $this->table(userid,callbackurl,gateway,amount,created_at) VALUES(:userid,:callbackurl,:gateway,:amount,:created_at)";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":userid", $this->userid);
        $stat->bindParam(":gateway", $this->gateway);
        $stat->bindParam(":callbackurl", $this->callbackurl);
        $stat->bindParam(":amount", $this->amount);
        $stat->bindParam(":created_at", time());
        $stat->execute();
        return DB::$pdoobj->lastInsertId();
    }

    public function Enable($id)
    {
        $sql = "UPDATE $this->table SET st=:st WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $st = 1;
        $stat->bindParam(":id", $id);
        $stat->bindParam(":st", $st);
        return $stat->execute();
    }

    public function Disble($id)
    {
        $sql = "UPDATE $this->table SET st=:st WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $st = 0;
        $stat->bindParam(":id", $id);
        $stat->bindParam(":st", $st);
        return $stat->execute();
    }
    public function updateRef($refid,$id)
    {
        $sql = "UPDATE $this->table SET refid=:refid WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":id", $id);
        $stat->bindParam(":refid", $refid);
        return $stat->execute();
    }
        public function setInvoiceAsPaid($resid,$id)
    {
        $sql = "UPDATE $this->table SET resid=:resid,st=:st,paid_at=:paid_at WHERE id=:id";
        $st=1;
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":id", $id);
        $stat->bindParam(":resid", $resid);
        $stat->bindParam(":st", $st);
        $stat->bindParam(":paid_at", time());
        return $stat->execute();
    }
    
        public function todayIncome()
    {
        
          date_default_timezone_set("Asia/Tehran");
          $date = new DateTime();
          $startOfDay = $date->setTime(0,0);
          $startOfDayTimestamp=$startOfDay->getTimestamp();
          $startOfNextDay = $date->modify('+1 day');
          $startOfNextDayTimestamp= $startOfNextDay->getTimestamp();

        $sql = "SELECT SUM(`amount`) as amount FROM $this->table  WHERE st=:st AND `paid_at`  BETWEEN :start_time  AND :end_time " ;
        $st=1;
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":st", $st);
        $stat->bindParam(":start_time",$startOfDayTimestamp );
        $stat->bindParam(":end_time", $startOfNextDayTimestamp);
        $stat->execute();
        $fetchAll=$stat->fetch();
        return number_format($fetchAll['amount']);
    }
}