<?php
require_once "../../classes/gateway.php";
require_once '../../classes/invoice.php';
require_once '../../classes/user.php';

$gateway = new Gateway();
$user = new User();
$invoice = new Invoice();
$invoiceid = $_GET['invoiceid'];

$gatewayInfo = $gateway->getOne(2);
$invoiceInfo = $invoice->getOne($invoiceid);
$userInfo = $user->getOne($invoiceInfo['userid']);

$transid = $_POST['transid'];

$data = [
    "pin" => $gatewayInfo['apikey'],
    "transid" => $transid,
    "amount" => $invoiceInfo['amount'],
];
$jsonData = json_encode($data);
$ch = curl_init('https://panel.aqayepardakht.ir/api/v2/verify');
curl_setopt($ch, CURLOPT_USERAGENT, 'aqayepardakht Rest Api v4');
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'Content-Length: ' . strlen($jsonData)]);

$result = curl_exec($ch);

$err = curl_error($ch);
curl_close($ch);
$result = json_decode($result, true);

if ($err) {
    echo "cURL Error #:" . $err;
} else {
    if ($result['code'] == "1") {
        $invoice->setInvoiceAsPaid($transid, $invoiceid);
        header('Location:' . urldecode($invoiceInfo["callbackurl"]));
     
    } else {
        switch ($result['code']) {
            case '-1':
                echo 'amount نمی تواند خالی باشد';
                break;

            case '-2':
                echo 'کد پین درگاه نمی تواند خالی باشد';
                break;

            case '-3':
                echo 'callback نمی تواند خالی باشد';
                break;

            case '-4':
                echo 'amount باید عددی باشد';
                break;

            case '-5':
                echo 'amount باید بین 1,000 تا 200,000,000 تومان باشد';
                break;

            case '-6':
                echo 'کد پین درگاه اشتباه هست';
                break;

            case '-7':
                echo 'transid نمی تواند خالی باشد';
                break;
            case '-8':
                echo 'تراکنش مورد نظر وجود ندارد';
                break;

            case '-9':
                echo 'کد پین درگاه با درگاه تراکنش مطابقت ندارد';
                break;
            case '-10':
                echo 'مبلغ با مبلغ تراکنش مطابقت ندارد';
                break;
            case '-11':
                echo 'درگاه درانتظار تایید و یا غیر فعال است';
                break;
            case '-12':
                echo 'امکان ارسال درخواست برای این پذیرنده وجود ندارد';
                break;
            case '-13':
                echo 'شماره کارت باید 16 رقم چسبیده بهم باشد';
                break;
            case '-14':
                echo 'درگاه برروی سایت دیگری درحال استفاده است';
                break;

            default:
                echo 'خطایی رخ داده است';
        }
    }
}


?>
