<?php

include_once 'classes/db.php';
include_once 'classes/user.php';
include_once 'classes/invoice.php';
include_once 'classes/func.php';

$user = new User();
$invoice = new Invoice();
$invoiceid = $_GET['id'];

if (isset($_GET['id'])) {
    $invoiceinfo = $invoice->getOne($_GET['id']);
    
    if ($invoiceinfo != false) {
        $userinfo = $user->getOne($invoiceinfo['userid']);
       
        if (($userinfo['code_ex'] !== null) && (time() < $userinfo['code_ex'])) {  // agar az ghabl code ersal shode bood
           $remained = time() < $userinfo['code_ex'] ? $userinfo['code_ex'] - time() : -1;
        } else {
            $code = rand(1000, 9999);

            if (SMS_ACTIVE) {
                verifySmsSend($userinfo['phone'], $code);
            } else {
                echo $code;
            }

            $code_ex = time() + 120;
            $user->UpdateVerifyCode($invoiceinfo['userid'], $code, $code_ex);
          
            $remained = $code_ex - time() ;
        }

        if (isset($_POST['submit'])) {
            $code = $_POST['code'];
            $userid = $_POST['userid'];
            $userinfo = $user->getOne($userid);

            if ($userinfo != false) {
                if ($code == $userinfo['code']) {
                    $user->UpdateVerifyMobile($userid);
                    header('location:auth.php?id=' . $userid . '&invoiceid=' . $invoiceid);
                } else {
                    $msg = 'لطفا کد را به درستی وارد کنید ';
                    $color = 'danger';
                }
            } else {
                die("Access Denied!");
            }
        } elseif (isset($_POST['resend'])) {
            $userinfo = $user->getOne($invoiceinfo['userid']);
            $code = rand(1000, 9999);

            if (SMS_ACTIVE) {
                verifySmsSend($userinfo['phone'], $code);
            } else {
                echo $code;
            }

            $code_ex = time() + 120;
            $remained = $code_ex - time();
            $user->UpdateVerifyCode($invoiceinfo['userid'], $code, $code_ex);
        }
    } else {
        die("Access Denied!");
    }
}
?>



<!DOCTYPE html>
<html lang="en" dir="rtl">
    <head>
        <meta charset="utf-8" />
        <title>تاییدیه کد ارسالی</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="user/assets/images/favicon.ico" />

        <!-- App css -->
        <link href="user/assets/css/config/default/bootstrap-rtl.min.css" rel="stylesheet" type="text/css" id="bs-default-stylesheet" />
        <link href="user/assets/css/config/default/app-rtl.min.css" rel="stylesheet" type="text/css" id="app-default-stylesheet" />

        <link href="user/assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css" id="bs-dark-stylesheet" disabled="disabled" />
        <link href="user/assets/css/config/default/app-dark-rtl.min.css" rel="stylesheet" type="text/css" id="app-dark-stylesheet" disabled="disabled" />

        <!-- icons -->
        <link href="user/assets/css/icons-rtl.min.css" rel="stylesheet" type="text/css" />
    </head>

    <body class="loading authentication-bg authentication-bg-pattern">
        <div class="account-pages my-5">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-9 ">
                        <div class="text-center">
                            <div class="row">
                                        <?php if ($msg != '') { ?>
                                <div class="alert alert-<?= $color ?> alert-dismissible fade show"
                                     style="margin-top: 15px"
                                     role="alert">
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                            aria-label="Close"></button>
                                    <?php echo $msg; ?>
                                </div>
                                <?php } ?>
                            </div>
                            <div class="card">
                                <div class="card-body p-4">
                                    <form  method="post">
                                        <input type="hidden" value="<?= $invoiceinfo['userid'] ?>" name="userid" />
                                        <div class="mb-3">
                                    <div <div class="col-md-12">
                                <div class="alert alert-primary bg-success text-white border-0" role="alert">
                                    <strong> مرحله تایید شماره تلفن از طریق پیامک ارسال شده !</strong>
                                 
                                    </div>
                                  </div>
                                           <div class="col-md-12">
                                            <div class="alert alert-warning">
                                                <div class="card-body">
                                                    <blockquote class="card-bodyquote mb-0">
                                                        
                                                        <p><i class="mdi mdi-alert"></i>  توجه داشته باشید که شماره موبایل و شماره ملی باید متعلق به یک نفر باشد. در غیر اینصورت سیستم پرداخت بانکی اجازه انجام تراکنش پرداخت را صادر نمی کند.</p>
                                                         
                                                        <p><i class="mdi mdi-alert"></i>  برای پرداخت حتما، فیلترشکن خود را خاموش کنید. درگاه فقط با آی‌پی ایران فعال است.</p>
                                                    </blockquote>
                                                </div>
                                            </div>
                                        </div>
                                            <label class="mb-3" for="code" class="form-label"> کدی که از طریق پیامک دریافت کردید را وارد کنید!</label>
                                            <input class="form-control" name="code" type="code" required 
                                            data-errormessage-value-missing="Something's missing" 
                                            data-errormessage-type-mismatch="Invalid!"  
                                        id="code" placeholder=" کدی که از طریق پیامک دریافت کردید را وارد کنید " />
                                        </div>
                                        
                                        <div class="mb-3  text-center">
                                          <button type="submit" name="submit" class="btn btn-success  waves-effect waves-light">
                                             تایید<span class="btn-label-right"><i class="mdi mdi-check-all"></i></span>
                                           </button>
                                         <a href="<?= $invoiceinfo['callbackurl'] ?>">
                                                   <button type="button" name="return" class="btn btn-danger  waves-effect waves-light">
                                             انصراف<span class="btn-label-right"><i class="mdi mdi-check-all"></i></span>
                                           </button>
                                         </a>
                                        </div>
                                           <input type="hidden" value="<?= $remained ?>" id="remained" />
                                           
                                           <div class="alert alert-info" role="alert" > <h6 id="timer" > </h6> 
                                        </div>
                                       </form>      
                                    <form  method="post">
                                       <button style="visibility: hidden;"  class="btn btn-success rounded-pill waves-effect waves-light" name="resend" id="resend" type="submit"> ارسال مجدد </button>
                                     </form>
                                    </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
        </div>

        <!-- end page -->

        <!-- Vendor js -->
        <script src="user/assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="user/assets/js/app.min.js"></script>
        <!--<div class="outline-form-field-sibling-buttons-container max-sm:ms-2 sm:col-span-3 ng-tns-c1522216626-55"><button baamtimer="" mat-stroked-button="" type="button" color="primary" class="disabled:!text-primary w-full ng-tns-c1522216626-55 mdc-button mdc-button--outlined mat-mdc-outlined-button mat-primary mat-mdc-button-base disabled-style" mat-ripple-loader-class-name="mat-mdc-button-ripple" disabled="">1:21</button></div>-->
        
<script>


// Update the count down every 1 second
var x = setInterval(function() {
// Find the distance between now and the count down date
var distance = document.getElementById("remained").value;
 
  // Time calculations for days, hours, minutes and seconds
  var minutes = Math.floor(distance / 60) ;
  var seconds = Math.floor(distance % ( 60)) ;
    
  // Output the result in an element with id="timer"
  document.getElementById("timer").innerHTML =  minutes + "m " + seconds + "s ";

  document.getElementById("remained").value = distance-1;
    
  // If the count down is over, write some text 
  if (distance < 0) {
    clearInterval(x);
    document.getElementById("timer").innerHTML = " مهلت به اتمام رسیده.برای ارسال مجدد دکمه مربوطه را کلیک نمایید ";
    
      document.getElementById("resend").style.visibility = "visible"; 
  }
}, 1000);
</script>


    </body>
</html>
